---
title: Changelog · Cloudflare Log Explorer docs
description: "The results table view of Log Search has been updated with
  additional functionality and a more streamlined user experience. Users can now
  easily:"
lastUpdated: 2025-06-27T07:53:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/log-explorer/changelog/
  md: https://developers.cloudflare.com/log-explorer/changelog/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/log-explorer.xml)

## 2025-09-11

**New results table view**

The results table view of **Log Search** has been updated with additional functionality and a more streamlined user experience. Users can now easily:

* Remove/add columns.
* Resize columns.
* Sort columns.
* Copy values from any field.

![New results table view](https://developers.cloudflare.com/_astro/new-table.C2Q8mWJ9_ZBUTGG.webp)

## 2025-09-11

**Contextual pivots**

Directly from [Log Search](https://developers.cloudflare.com/log-explorer/log-search/) results, customers can pivot to other parts of the Cloudflare dashboard to immediately take action as a result of their investigation.

From the `http_requests` or `fw_events` dataset results, right click on an IP Address or JA3 Fingerprint to pivot to the Investigate portal to lookup the reputation of an IP address or JA3 fingerprint.

![Investigate IP address](https://developers.cloudflare.com/_astro/investigate-ip-address.BMVSMzDi_1VfOkF.webp)

Easily learn about error codes by linking directly to our documentation from the **EdgeResponseStatus** or **OriginResponseStatus** fields.

![View documentation](https://developers.cloudflare.com/_astro/view-documentation.Cem5QgeO_1eU6E7.webp)

From the `gateway_http` dataset, click on a **policyid** to link directly to the Zero Trust dashboard to review or make changes to a specific Gateway policy.

![View policy](https://developers.cloudflare.com/_astro/policyid.CVjEdahj_1GMC1S.webp)

## 2025-09-03

**Logging headers and cookies using custom fields**

[Log Explorer](https://developers.cloudflare.com/log-explorer/) now supports logging and filtering on header or cookie fields in the [`http_requests` dataset](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/http_requests/).

Create a custom field to log desired header or cookie values into the `http_requests` dataset and Log Explorer will import these as searchable fields. Once configured, use the custom SQL editor in Log Explorer to view or filter on these requests.

![Edit Custom fields](https://developers.cloudflare.com/_astro/edit-custom-fields.Cy4qXSpL_ZWwGsu.webp)

For more details, refer to [Headers and cookies](https://developers.cloudflare.com/log-explorer/log-search/#headers-and-cookies).

## 2025-08-15

**Extended retention**

Customers can now rely on Log Explorer to meet their log retention compliance requirements.

Contract customers can choose to store their logs in Log Explorer for up to two years, at an additional cost of $0.10 per GB per month. Customers interested in this feature can contact their account team to have it added to their contract.

## 2025-07-09

**Usage tracking**

[Log Explorer](https://developers.cloudflare.com/log-explorer/) customers can now monitor their data ingestion volume to keep track of their billing. Monthly usage is displayed at the top of the [Log Search](https://developers.cloudflare.com/log-explorer/log-search/) and [Manage Datasets](https://developers.cloudflare.com/log-explorer/manage-datasets/) screens in Log Explorer.

![Ingested data](https://developers.cloudflare.com/_astro/ingested-data.D2flqRIu_2c6hqU.webp)

## 2025-06-18

**Log Explorer is GA**

[Log Explorer](https://developers.cloudflare.com/log-explorer/) is now GA, providing native observability and forensics for traffic flowing through Cloudflare.

Search and analyze your logs, natively in the Cloudflare dashboard. These logs are also stored in Cloudflare's network, eliminating many of the costs associated with other log providers.

![Log Explorer dashboard](https://developers.cloudflare.com/_astro/log-explorer-dash.CJSVLZ7Y_JFAqV.webp)

With Log Explorer, you can now:

* **Monitor security and performance issues with custom dashboards** – use natural language to define charts for measuring response time, error rates, top statistics and more.
* **Investigate and troubleshoot issues with Log Search** – use data type-aware search filters or custom sql to investigate detailed logs.
* **Save time and collaborate with saved queries** – save Log Search queries for repeated use or sharing with other users in your account.
* **Access Log Explorer at the account and zone level** – easily find Log Explorer at the account and zone level for querying any dataset.

For help getting started, refer to [our documentation](https://developers.cloudflare.com/log-explorer/).
